<?php
//Incluimos funcin de conexin.
include_once('class.ConectorServisim.php');
try {
	//1. Creamos nuevo objeto de conexin.
	$conector = new ConectorServisim();
	//1.1 Establecemos EndPoint de Servisim.
	$conector->establecerEndPoint('http://201.150.37.20:8080/ServisimTest/TimbradoCFDi');
	//1.2 Establecemos la accin a realizar.
	$conector->establecerSoapAction('http://controller.timbrado.ws.servisim.com/', 'timbrarCFDi');
	//1.3 Establecemos los datos de acceso al servicio web.
	$conector->establecerAcceso('1', 'servisim');
	//2. Crear peticin
	$conector->crearPeticion();
	//3. Asignamos datos a la peticin.
	//3.1 Asignamos Identificador UNICO del CFDi. sugerencia SERIE+FOLIO
	$conector->asignarEnPeticion('Id', 'FAC-001');
	//3.2 Asignamos el Contenido del XML ya sellado por el Emisor.
	/*
	$conector->asignarEnPeticion('Xml', '<?xml version="1.0" encoding="UTF-8"?>
<cfdi:Comprobante xmlns:cfdi="http://www.sat.gob.mx/cfd/3" xmlns:tfd="http://www.sat.gob.mx/TimbreFiscalDigital" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" LugarExpedicion="Mxico" metodoDePago="efectivo" tipoDeComprobante="ingreso" total="0.174" subTotal="0.15" certificado="MIIEdDCCA1ygAwIBAgIUMjAwMDEwMDAwMDAxMDAwMDU4NjcwDQYJKoZIhvcNAQEFBQAwggFvMRgwFgYDVQQDDA9BLkMuIGRlIHBydWViYXMxLzAtBgNVBAoMJlNlcnZpY2lvIGRlIEFkbWluaXN0cmFjacOzbiBUcmlidXRhcmlhMTgwNgYDVQQLDC9BZG1pbmlzdHJhY2nDs24gZGUgU2VndXJpZGFkIGRlIGxhIEluZm9ybWFjacOzbjEpMCcGCSqGSIb3DQEJARYaYXNpc25ldEBwcnVlYmFzLnNhdC5nb2IubXgxJjAkBgNVBAkMHUF2LiBIaWRhbGdvIDc3LCBDb2wuIEd1ZXJyZXJvMQ4wDAYDVQQRDAUwNjMwMDELMAkGA1UEBhMCTVgxGTAXBgNVBAgMEERpc3RyaXRvIEZlZGVyYWwxEjAQBgNVBAcMCUNveW9hY8OhbjEVMBMGA1UELRMMU0FUOTcwNzAxTk4zMTIwMAYJKoZIhvcNAQkCDCNSZXNwb25zYWJsZTogSMOpY3RvciBPcm5lbGFzIEFyY2lnYTAeFw0xMjA3MjcxNzAyMDBaFw0xNjA3MjcxNzAyMDBaMIHbMSkwJwYDVQQDEyBBQ0NFTSBTRVJWSUNJT1MgRU1QUkVTQVJJQUxFUyBTQzEpMCcGA1UEKRMgQUNDRU0gU0VSVklDSU9TIEVNUFJFU0FSSUFMRVMgU0MxKTAnBgNVBAoTIEFDQ0VNIFNFUlZJQ0lPUyBFTVBSRVNBUklBTEVTIFNDMSUwIwYDVQQtExxBQUEwMTAxMDFBQUEgLyBIRUdUNzYxMDAzNFMyMR4wHAYDVQQFExUgLyBIRUdUNzYxMDAzTURGUk5OMDkxETAPBgNVBAsTCFVuaWRhZCAxMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQC2TTQSPONBOVxpXv9wLYo8jezBrb34i/tLx8jGdtyy27BcesOav2c1NS/Gdv10u9SkWtwdy34uRAVe7H0a3VMRLHAkvp2qMCHaZc4T8k47Jtb9wrOEh/XFS8LgT4y5OQYo6civfXXdlvxWU/gdM/e6I2lg6FGorP8H4GPAJ/qCNwIDAQABox0wGzAMBgNVHRMBAf8EAjAAMAsGA1UdDwQEAwIGwDANBgkqhkiG9w0BAQUFAAOCAQEATxMecTpMbdhSHo6KVUg4QVF4Op2IBhiMaOrtrXBdJgzGotUFcJgdBCMjtTZXSlq1S4DG1jr8p4NzQlzxsdTxaB8nSKJ4KEMgIT7E62xRUj15jI49qFz7f2uMttZLNThipunsN/NF1XtvESMTDwQFvas/Ugig6qwEfSZc0MDxMpKLEkEePmQwtZD+zXFSMVa6hmOu4M+FzGiRXbj4YJXn9Myjd8xbL/c+9UIcrYoZskxDvMxc6/6M3rNNDY3OFhBK+V/sPMzWWGt8S1yjmtPfXgFs1t65AZ2hcTwTAuHrKwDatJ1ZPfa482ZBROAAX1waz7WwXp0gso7sDCm2/yUVww==" noCertificado="20001000000100005867" formaDePago="PAGO EN UNA SOLA EXHIBICION" sello="jU5Yg6YgYDiYv0PVqFMYN0Rlx1Tc/ekc+vNWF0HIlgov1HwGyXfrNZNH2KlH4UfXdpR4bYYJKCmxOq3wtyqkzGHQaconVTq4P9h9PrnbTMGz1VqCTGpZZKfx9pyOviB4xOsiABJTD4BoXu8SC0klP80dBnPVxPcTg9eOmUPoSy8=" fecha="2012-09-11T15:43:22" version="3.2" xsi:schemaLocation="http://www.sat.gob.mx/cfd/3  http://www.sat.gob.mx/sitio_internet/cfd/3/cfdv32.xsd">
    <cfdi:Emisor nombre="Servisim S.A. de C.V." rfc="AAA010101AAA">
        <cfdi:DomicilioFiscal codigoPostal="07630" pais="Mexico" estado="Distrito Federal" municipio="Gustavo A. Madero" colonia="San Jose de la Escalera" noExterior="1829" calle="Calzada Vallejo"/>
        <cfdi:ExpedidoEn codigoPostal="07630" pais="Mexico" estado="Distrito Federal" municipio="Gustavo A. Madero" colonia="San Jose de la Escalera" noExterior="1829" calle="Calzada Vallejo"/>
        <cfdi:RegimenFiscal Regimen="simplificado"/>
    </cfdi:Emisor>
    <cfdi:Receptor nombre="Cliente General" rfc="XAXX010101000">
        <cfdi:Domicilio pais="Mxico"/>
    </cfdi:Receptor>
    <cfdi:Conceptos>
        <cfdi:Concepto importe="0.15" valorUnitario="0.15" descripcion="1 Timbre" unidad="PZA" cantidad="1"/>
    </cfdi:Conceptos>
    <cfdi:Impuestos>
        <cfdi:Traslados>
            <cfdi:Traslado importe="0.024" tasa="16.0" impuesto="IVA"/>
        </cfdi:Traslados>
    </cfdi:Impuestos>
</cfdi:Comprobante>');
	*/
	$conector->asignarEnPeticion('Xml','<?xml version="1.0" encoding="UTF-8"?>
<cfdi:Comprobante xmlns:cfdi="http://www.sat.gob.mx/cfd/3" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.sat.gob.mx/cfd/3  http://www.sat.gob.mx/sitio_internet/cfd/3/cfdv33.xsd" Version="3.3" Folio="43914" Fecha="2019-01-28T16:48:24" Sello="QiyZ2LSCs7ZEbHodQHkkxI+9er9fcryfDIW3LmuCqMhVjTokp9Bd/+2SsdcAztP+6zslusZS3ZGzzM6W/kdBeNSv+JHjKRjBtVYP2KwjL1ydISB6RsmOpIavFR6CaQ4WKP9DD/z+B+v4/eeBJOq14culCVc+KL4Ax4jNV2ZPL1c=" NoCertificado="00001000000305973349" Certificado="MIIEYjCCA0qgAwIBAgIUMDAwMDEwMDAwMDAzMDU5NzMzNDkwDQYJKoZIhvcNAQEFBQAwggGKMTgwNgYDVQQDDC9BLkMuIGRlbCBTZXJ2aWNpbyBkZSBBZG1pbmlzdHJhY2nDs24gVHJpYnV0YXJpYTEvMC0GA1UECgwmU2VydmljaW8gZGUgQWRtaW5pc3RyYWNpw7NuIFRyaWJ1dGFyaWExODA2BgNVBAsML0FkbWluaXN0cmFjacOzbiBkZSBTZWd1cmlkYWQgZGUgbGEgSW5mb3JtYWNpw7NuMR8wHQYJKoZIhvcNAQkBFhBhY29kc0BzYXQuZ29iLm14MSYwJAYDVQQJDB1Bdi4gSGlkYWxnbyA3NywgQ29sLiBHdWVycmVybzEOMAwGA1UEEQwFMDYzMDAxCzAJBgNVBAYTAk1YMRkwFwYDVQQIDBBEaXN0cml0byBGZWRlcmFsMRQwEgYDVQQHDAtDdWF1aHTDqW1vYzEVMBMGA1UELRMMU0FUOTcwNzAxTk4zMTUwMwYJKoZIhvcNAQkCDCZSZXNwb25zYWJsZTogQ2xhdWRpYSBDb3ZhcnJ1YmlhcyBPY2hvYTAeFw0xNTAxMzAyMTMyMjBaFw0xOTAxMzAyMTMyMjBaMIGuMRowGAYDVQQDExFDT05URU5VUiBTQSBERSBDVjEaMBgGA1UEKRMRQ09OVEVOVVIgU0EgREUgQ1YxGjAYBgNVBAoTEUNPTlRFTlVSIFNBIERFIENWMSUwIwYDVQQtExxDT045OTExMThBVTUgLyBUT01SODIwMTE5QTMzMR4wHAYDVQQFExUgLyBUT01SODIwMTE5SERGU1JMMDYxETAPBgNVBAsTCGNvbnRlbnVyMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDj/pvu7J9BwotWfJINRHCN64aJkTewCn+4VO8wU5LJnGm3JR7Uqf5lCJ8zTW2T0OSQWDWt3IfZr/rlOM6+86seFV2rtnHHBAjSKGzsHqzhYIIW8JwqG4P2C22GZstSKLxYqNQtEO1EStG2KsuGyaLAzpl6BpmcKTm6gDLOy0RJqQIDAQABox0wGzAMBgNVHRMBAf8EAjAAMAsGA1UdDwQEAwIGwDANBgkqhkiG9w0BAQUFAAOCAQEAV6wMTMScSW+J2aTjjC6i1hbcmmZ7CsSy72BwvLIpDPLsOmdcNg+CGzFQGZFDAsRpKogERum3rAxkqJkORVe+Kjb/61LIhn+yZRtOXK3Srp0PH2o6Jh0jSfeF6hi+XLKfizG7JinxKMLrAYIU7CTKc+9INiog9p6C2xp4szo40vAQq7MODvhlzY34IgUH/7e2hBhVcLgpud6PVsb53HK65CqelR2EYGwqUECH4/P6Xe2JqZw9CGxMkFXitC9U8uImVFvsVjd0kOYemU22Cs+65pleJspPT4hT3xqU22WgIF2sYhF7DlxI3X8hUEH7qTJKmWBN7XVD5J/+gLVSmxS7Dw==" SubTotal="9655.18" Moneda="MXN" Total="11200.01" TipoDeComprobante="I" FormaPago="01" MetodoPago="PUE"  LugarExpedicion="53370">
	<cfdi:Emisor Rfc="CON991118AU5" Nombre="CONTENUR S.A. DE C.V." RegimenFiscal="601" />
	<cfdi:Receptor Rfc="XAXX010101000" Nombre="RAFAEL GONZALEZ ANZURA" UsoCFDI="G01" />
	<cfdi:Conceptos>
		<cfdi:Concepto ClaveProdServ="46181704" ClaveUnidad="H87" NoIdentificacion="CICECE" Cantidad="10" Unidad="Pieza" Descripcion="CASCO IGA CLASE E" ValorUnitario="130.00" Importe="1300.00" Descuento="0.00">
				<cfdi:Impuestos>
					<cfdi:Traslados>
						<cfdi:Traslado Base="1300.00" Impuesto="002" TipoFactor="Tasa" TasaOCuota="0.16" Importe="208.00" />
					</cfdi:Traslados>
				</cfdi:Impuestos>
		</cfdi:Concepto>
		<cfdi:Concepto ClaveProdServ="72101516" ClaveUnidad="H87" NoIdentificacion="EXT4.5KG" Cantidad="1" Unidad="Pieza" Descripcion="EXTINTOR DE 4.5 KG" ValorUnitario="1550.00" Importe="1550.00" Descuento="0.00">
				<cfdi:Impuestos>
					<cfdi:Traslados>
						<cfdi:Traslado Base="1550.00" Impuesto="002" TipoFactor="Tasa" TasaOCuota="0.16" Importe="248.00" />
					</cfdi:Traslados>
				</cfdi:Impuestos>
		</cfdi:Concepto>
		<cfdi:Concepto ClaveProdServ="48111108" ClaveUnidad="H87" NoIdentificacion="BOTIQUIN" Cantidad="1" Unidad="Pieza" Descripcion="BOTIQUIN PRIMEROS AUXILIOS" ValorUnitario="435.00" Importe="435.00" Descuento="0.00">
				<cfdi:Impuestos>
					<cfdi:Traslados>
						<cfdi:Traslado Base="435.00" Impuesto="002" TipoFactor="Tasa" TasaOCuota="0.16" Importe="69.60" />
					</cfdi:Traslados>
				</cfdi:Impuestos>
		</cfdi:Concepto>
		<cfdi:Concepto ClaveProdServ="55121700" ClaveUnidad="H87" NoIdentificacion="BP11425X35" Cantidad="1" Unidad="Pieza" Descripcion="SENAL DE 25X35 DE NO ESTACIONARSE" ValorUnitario="65.00" Importe="65.00" Descuento="0.00">
				<cfdi:Impuestos>
					<cfdi:Traslados>
						<cfdi:Traslado Base="65.00" Impuesto="002" TipoFactor="Tasa" TasaOCuota="0.16" Importe="10.40" />
					</cfdi:Traslados>
				</cfdi:Impuestos>
		</cfdi:Concepto>
		<cfdi:Concepto ClaveProdServ="55121700" ClaveUnidad="H87" NoIdentificacion="BP1320X30" Cantidad="1" Unidad="Pieza" Descripcion="SENAL DE 20X30 DE SALIDA EXIT" ValorUnitario="40.00" Importe="40.00" Descuento="0.00">
				<cfdi:Impuestos>
					<cfdi:Traslados>
						<cfdi:Traslado Base="40.00" Impuesto="002" TipoFactor="Tasa" TasaOCuota="0.16" Importe="6.40" />
					</cfdi:Traslados>
				</cfdi:Impuestos>
		</cfdi:Concepto>
		<cfdi:Concepto ClaveProdServ="55121700" ClaveUnidad="H87" NoIdentificacion="BP5220X20" Cantidad="1" Unidad="Pieza" Descripcion="SENAL DE 20X20 DE NO FUMAR" ValorUnitario="39.00" Importe="39.00" Descuento="0.00">
				<cfdi:Impuestos>
					<cfdi:Traslados>
						<cfdi:Traslado Base="39.00" Impuesto="002" TipoFactor="Tasa" TasaOCuota="0.16" Importe="6.24" />
					</cfdi:Traslados>
				</cfdi:Impuestos>
		</cfdi:Concepto>
		<cfdi:Concepto ClaveProdServ="01010101" ClaveUnidad="H87" NoIdentificacion="art_temp" Cantidad="2" Unidad="Pieza" Descripcion="20x30" ValorUnitario="169.59" Importe="339.18" Descuento="0.00">
				<cfdi:Impuestos>
					<cfdi:Traslados>
						<cfdi:Traslado Base="339.18" Impuesto="002" TipoFactor="Tasa" TasaOCuota="0.16" Importe="54.27" />
					</cfdi:Traslados>
				</cfdi:Impuestos>
		</cfdi:Concepto>
		<cfdi:Concepto ClaveProdServ="55121700" ClaveUnidad="H87" NoIdentificacion="BP7525X35" Cantidad="1" Unidad="Pieza" Descripcion="SENAL DE 25X35 DE EXTINTOR" ValorUnitario="75.00" Importe="75.00" Descuento="0.00">
				<cfdi:Impuestos>
					<cfdi:Traslados>
						<cfdi:Traslado Base="75.00" Impuesto="002" TipoFactor="Tasa" TasaOCuota="0.16" Importe="12.00" />
					</cfdi:Traslados>
				</cfdi:Impuestos>
		</cfdi:Concepto>
		<cfdi:Concepto ClaveProdServ="55121700" ClaveUnidad="H87" NoIdentificacion="7940 F" Cantidad="3" Unidad="Pieza" Descripcion="SENAL PELIGRO" ValorUnitario="95.00" Importe="285.00" Descuento="0.00">
				<cfdi:Impuestos>
					<cfdi:Traslados>
						<cfdi:Traslado Base="285.00" Impuesto="002" TipoFactor="Tasa" TasaOCuota="0.16" Importe="45.60" />
					</cfdi:Traslados>
				</cfdi:Impuestos>
		</cfdi:Concepto>
		<cfdi:Concepto ClaveProdServ="55121700" ClaveUnidad="H87" NoIdentificacion="BP1420X30" Cantidad="3" Unidad="Pieza" Descripcion="SENAL DE 20X30 DE SALIDA DE EMERGENCIA" ValorUnitario="52.00" Importe="156.00" Descuento="0.00">
				<cfdi:Impuestos>
					<cfdi:Traslados>
						<cfdi:Traslado Base="156.00" Impuesto="002" TipoFactor="Tasa" TasaOCuota="0.16" Importe="24.96" />
					</cfdi:Traslados>
				</cfdi:Impuestos>
		</cfdi:Concepto>
		<cfdi:Concepto ClaveProdServ="55121700" ClaveUnidad="H87" NoIdentificacion="BP0920X30" Cantidad="3" Unidad="Pieza" Descripcion="SENAL DE 20X30 DE RUTA DE EVACUACION DERECHA" ValorUnitario="52.00" Importe="156.00" Descuento="0.00">
				<cfdi:Impuestos>
					<cfdi:Traslados>
						<cfdi:Traslado Base="156.00" Impuesto="002" TipoFactor="Tasa" TasaOCuota="0.16" Importe="24.96" />
					</cfdi:Traslados>
				</cfdi:Impuestos>
		</cfdi:Concepto>
		<cfdi:Concepto ClaveProdServ="55121700" ClaveUnidad="H87" NoIdentificacion="BP7825X35" Cantidad="1" Unidad="Pieza" Descripcion="SENAL DE 25X35 DE CASCO" ValorUnitario="65.00" Importe="65.00" Descuento="0.00">
				<cfdi:Impuestos>
					<cfdi:Traslados>
						<cfdi:Traslado Base="65.00" Impuesto="002" TipoFactor="Tasa" TasaOCuota="0.16" Importe="10.40" />
					</cfdi:Traslados>
				</cfdi:Impuestos>
		</cfdi:Concepto>
		<cfdi:Concepto ClaveProdServ="46161519" ClaveUnidad="H87" NoIdentificacion="CPREC" Cantidad="2" Unidad="Pieza" Descripcion="CINTA PRECAUCION" ValorUnitario="120.00" Importe="240.00" Descuento="0.00">
				<cfdi:Impuestos>
					<cfdi:Traslados>
						<cfdi:Traslado Base="240.00" Impuesto="002" TipoFactor="Tasa" TasaOCuota="0.16" Importe="38.40" />
					</cfdi:Traslados>
				</cfdi:Impuestos>
		</cfdi:Concepto>
		<cfdi:Concepto ClaveProdServ="24112207" ClaveUnidad="H87" NoIdentificacion="BCTCIN220" Cantidad="2" Unidad="Pieza" Descripcion="TAMBO  CAPACIDAD 220 LTS" ValorUnitario="1450.00" Importe="2900.00" Descuento="0.00">
				<cfdi:Impuestos>
					<cfdi:Traslados>
						<cfdi:Traslado Base="2900.00" Impuesto="002" TipoFactor="Tasa" TasaOCuota="0.16" Importe="464.00" />
					</cfdi:Traslados>
				</cfdi:Impuestos>
		</cfdi:Concepto>
		<cfdi:Concepto ClaveProdServ="53103100" ClaveUnidad="H87" NoIdentificacion="C13ECO" Cantidad="21" Unidad="Pieza" Descripcion="CHALECO ECONOMICO" ValorUnitario="85.00" Importe="1785.00" Descuento="0.00">
				<cfdi:Impuestos>
					<cfdi:Traslados>
						<cfdi:Traslado Base="1785.00" Impuesto="002" TipoFactor="Tasa" TasaOCuota="0.16" Importe="285.60" />
					</cfdi:Traslados>
				</cfdi:Impuestos>
		</cfdi:Concepto>
		<cfdi:Concepto ClaveProdServ="01010101" ClaveUnidad="H87" NoIdentificacion="art_temp" Cantidad="1" Unidad="Pieza" Descripcion="Bp9125x35 USO DE GAFETE" ValorUnitario="65.00" Importe="65.00" Descuento="0.00">
				<cfdi:Impuestos>
					<cfdi:Traslados>
						<cfdi:Traslado Base="65.00" Impuesto="002" TipoFactor="Tasa" TasaOCuota="0.16" Importe="10.40" />
					</cfdi:Traslados>
				</cfdi:Impuestos>
		</cfdi:Concepto>
		<cfdi:Concepto ClaveProdServ="55121700" ClaveUnidad="H87" NoIdentificacion="BP4640X40" Cantidad="1" Unidad="Pieza" Descripcion="SENAL DE 40X40 DE PUNTO DE REUNION" ValorUnitario="160.00" Importe="160.00" >
				<cfdi:Impuestos>
					<cfdi:Traslados>
						<cfdi:Traslado Base="160.00" Impuesto="002" TipoFactor="Tasa" TasaOCuota="0.16" Importe="25.60" />
					</cfdi:Traslados>
				</cfdi:Impuestos>
		</cfdi:Concepto>
		</cfdi:Conceptos>
	<cfdi:Impuestos TotalImpuestosTrasladados="1544.83">
   		<cfdi:Traslados>
			<cfdi:Traslado Impuesto="002" TipoFactor="Tasa" TasaOCuota="0.16" Importe="1544.83" />
		</cfdi:Traslados>
	</cfdi:Impuestos>
</cfdi:Comprobante> ');
	//4. consumir servicio
	$conector->consumirServicio();
	//5. Obtener datos de la respuesta
	echo 'ID ERROR: ';
	echo $conector->obtenerDeRespuesta('IdError');
	echo '<br/>ERROR: ';
	echo $conector->obtenerDeRespuesta('Error');
	echo '<br/>UUID: ';
	echo $conector->obtenerDeRespuesta('Uuid');
	echo '<br/>FECHA TIMBRE: ';
	echo $conector->obtenerDeRespuesta('FechaTimbre');
	echo '<br/>XML LENGTH :';
	//5.5 La variable es muy grande y echo no la muestra, para efectos de prueba mostramos su tamao
	echo strlen($conector->obtenerDeRespuesta('Xml'));
}
catch (Exception $ex){
	echo $ex->getMessage();
}

?>