<?php 

header('X-Frame-Options: GOFORIT');

session_start();
date_default_timezone_set('America/Mexico_City');
error_reporting(0);

require ("settings.php");
require ("language/$cfg_language");
require ("classes/db_functions.php");
require ("classes/security_functions.php");
require ("classes/display.php");
require ("classes/form.php");

$lang=new language();
$dbf=new db_functions($cfg_server,$cfg_username,$cfg_password,$cfg_database,$cfg_tableprefix,$cfg_theme,$lang);
$sec_index=new security_functions($dbf,'Public',$lang);
if(!$sec_index->isLoggedIn()) header ("location: login.php");
$display=new display($dbf->conn,$cfg_theme,$cfg_currency_symbol,$lang);
$user_tablename = $cfg_tableprefix.'users';
$branch_tablename = $cfg_tableprefix.'branches';
$auth = $dbf->idToField($user_tablename,'type',$_SESSION['session_user_id']);
$userLoginName= $dbf->idToField($user_tablename,'username',$_SESSION['session_user_id']);
$userBranch_id= $dbf->idToField($user_tablename,'branch_id',$_SESSION['session_user_id']);
$userBranch_name= $dbf->idToField($branch_tablename,'branch_name',$userBranch_id);

if (isset($_POST['path_id']))
	$page_path = $_POST['path_id'];
elseif($auth=="Report Viewer")
	$page_path = "reports/escoge_fecha_maestro";
else $page_path = "home";

require ("head.php"); 
require ($page_path.".php");
require ("foot.php"); 
?>