<?php
session_start(); 
include ("../settings.php");
include ("../language/$cfg_language");
include ("../classes/db_functions.php");
include ("../classes/security_functions.php");
include ("../classes/form.php");
include ("../classes/display.php");

$lang=new language();
$dbf=new db_functions($cfg_server,$cfg_username,$cfg_password,$cfg_database,$cfg_tableprefix,$cfg_theme,$lang);
$sec=new security_functions($dbf,'SuperAdmin',$lang);
$display=new display($dbf->conn,$cfg_theme,$cfg_currency_symbol,$lang);

if(!$sec->isLoggedIn())
{
	header ("location: ../login.php");
	exit();
}
$brandtable=$cfg_tableprefix.'brands';
$categorytable=$cfg_tableprefix.'categories';
$suppliertable=$cfg_tableprefix.'suppliers';
$colortable=$cfg_tableprefix.'color';

$tb1=mysqli_query($dbf->conn,"SELECT id FROM $brandtable");
$tb2=mysqli_query($dbf->conn,"SELECT id FROM $categorytable");
$tb3=mysqli_query($dbf->conn,"SELECT id FROM $suppliertable");

if(mysqli_num_rows($tb1)==0 or mysqli_num_rows($tb2)==0 or mysqli_num_rows($tb3)==0)
{
	echo $lang->brandsCategoriesSupplierError;
	exit();
}

$item_name_value='';
$description_value='';
$item_number_value='';
$size_value='';
$brand_id_value='';
$category_id_value='';
$supplier_id_value='';
$buy_price_value='';
$unit_price_value='';
$tax_percent_value='';
$supplier_catalogue_number_value='';
$total_cost_value='';
$reorder_level_value='';
$orden_value='';
$mostrar_value='';
$c_ClaveProdServ_id_value=0;		// NULL
$c_ClaveUnidad_id_value=1070;		// id: 1070 => Pieza / H87
$colores='';
$descripcion_2='';
$informacion_adicional='';
$capacidad='';
$peso='';
$imagen_chica='';
$imagen_grande='';
$imagen_grande_2='';
$imagen_grande_3='';
$imagen_grande_4='';
$imagen_grande_5='';
$id='unknown';

if(isset($_GET['action']))
{
	$action=$_GET['action'];
}
else
{
	$action="insert";
}

if($action=="update")
{
	$title_form = $lang->updateItem;
	if(isset($_GET['id']))
	{
		$id=$_GET['id'];
		$tablename = $cfg_tableprefix.'items';
		$result = mysqli_query($dbf->conn,"SELECT * FROM $tablename WHERE id=\"$id\"");
		$row = mysqli_fetch_assoc($result);
		$item_name_value=$row['item_name'];
		$item_number_value=$row['item_number'];
		$size_value=$row['size'];
		$description_value=$row['description'];
		$brand_id_value=$row['brand_id'];
		$category_id_value=$row['category_id'];
		$supplier_id_value=$row['supplier_id'];
		$buy_price_value=$row['buy_price'];
		$unit_price_value=$row['unit_price'];
		$supplier_catalogue_number_value=$row['supplier_catalogue_number'];
		$tax_percent_value=$row['tax_percent'];
		$total_cost_value=$row['total_cost'];
		$reorder_level_value=$row['reorder_level'];
		$orden_value=$row['orderf'];
		$mostrar_value=$row['mostrar'];
		$c_ClaveProdServ_id_value=$row['c_ClaveProdServ_id'];
		$c_ClaveUnidad_id_value=$row['c_ClaveUnidad_id'];
        $colores=$row['colores'];
        $descripcion_2=$row['descripcion_2'];
        $informacion_adicional=$row['informacion_adicional'];
        $capacidad=$row['capacidad'];
        $peso=$row['peso'];
        $imagen0=$row['imagen_chica'];
        $imagen1=$row['imagen_grande'];
        $imagen2=$row['imagen_grande_2'];
        $imagen3=$row['imagen_grande_3'];
        $imagen4=$row['imagen_grande_4'];
        $imagen5=$row['imagen_grande_5'];
		$id=$row['id'];
	}	
}
else
{
	$title_form = $lang->addItem;
}
$f1=new form('index.php','POST','items',$title_form,$lang,true);
$f1->createInputField($lang->itemName,'text','item_name',$item_name_value,NULL,true,false);
$f1->createInputField($lang->description,'text','description',$description_value,"col_last",true,false);
$f1->createInputField("Medidas: ",'text','size',$size_value,NULL,false,false);						// Falta pasar a variable
$f1->createInputField($lang->itemNumber,'text','item_number',$item_number_value,"col_last",true,false);

$brandtable = $cfg_tableprefix.'brands';
$brand_option_titles=$dbf->getAllElements("$brandtable",'brand','brand');
array_unshift($brand_option_titles,$dbf->idToField("$brandtable",'brand',"$brand_id_value"));
$brand_option_values=$dbf->getAllElements("$brandtable",'id','brand');
array_unshift($brand_option_values,$brand_id_value);
$f1->createSelectField($lang->brand,'brand_id',$brand_option_values,$brand_option_titles,NULL);

$categorytable = $cfg_tableprefix.'categories';
$category_option_titles=$dbf->getAllElements("$categorytable",'category','category');
array_unshift($category_option_titles,$dbf->idToField("$categorytable",'category',"$category_id_value"));
$category_option_values=$dbf->getAllElements("$categorytable",'id','category');
array_unshift($category_option_values,$category_id_value);
$f1->createSelectField($lang->category,'category_id',$category_option_values,$category_option_titles,"col_last");

$suppliertable = $cfg_tableprefix.'suppliers';
$supplier_option_titles=$dbf->getAllElements("$suppliertable",'supplier','supplier');
array_unshift($supplier_option_titles,$dbf->idToField("$suppliertable",'supplier',"$supplier_id_value"));
$supplier_option_values=$dbf->getAllElements("$suppliertable",'id','supplier');
array_unshift($supplier_option_values,$supplier_id_value);
$f1->createSelectField($lang->supplier,'supplier_id',$supplier_option_values,$supplier_option_titles,NULL);

$f1->createInputField($lang->buyingPrice,'text','buy_price',$buy_price_value,"col_last",true,false);
$f1->createInputField($lang->sellingPrice." (".$lang->wo." ".$lang->tax.")",'text','unit_price',$unit_price_value,NULL,true,false);
$f1->createInputField($lang->tax." (%)",'text','tax_percent',$tax_percent_value,"col_last",true,false);
$f1->createInputField($lang->supplierCatalogue,'text','supplier_catalogue_number',$supplier_catalogue_number_value,NULL,false,false);
$f1->createInputField($lang->reorderLevel,'text','reorder_level',$reorder_level_value,"col_last",false,false);
$f1->createInputField("Orden: ",'text','orden',$orden_value,NULL,false,false);						// Falta pasar a variable
$f1->createInputField("Mostrar: ",'text','mostrar',$mostrar_value,"col_last",true,false);			// Falta pasar a variable

$c_ClaveProdServ_table = $cfg_tableprefix.'c_ClaveProdServ';
$c_ClaveProdServ_option_titles=$dbf->getAllElements($c_ClaveProdServ_table,'Descripcion','Descripcion');
array_unshift($c_ClaveProdServ_option_titles,$dbf->idToField($c_ClaveProdServ_table,'Descripcion',$c_ClaveProdServ_id_value));
$c_ClaveProdServ_option_values=$dbf->getAllElements($c_ClaveProdServ_table,'id','Descripcion');
array_unshift($c_ClaveProdServ_option_values,$c_ClaveProdServ_id_value);
$f1->createSelectField("Producto SAT: ",'c_ClaveProdServ_id',$c_ClaveProdServ_option_values,$c_ClaveProdServ_option_titles,NULL);

$c_ClaveUnidad_table = $cfg_tableprefix.'c_ClaveUnidad';
$c_ClaveUnidad_option_titles=$dbf->getAllElements($c_ClaveUnidad_table,'Nombre','Nombre');
array_unshift($c_ClaveUnidad_option_titles,$dbf->idToField($c_ClaveUnidad_table,'Nombre',$c_ClaveUnidad_id_value));
$c_ClaveUnidad_option_values=$dbf->getAllElements($c_ClaveUnidad_table,'id','Nombre');
array_unshift($c_ClaveUnidad_option_values,$c_ClaveUnidad_id_value);
$f1->createSelectField("Unidad SAT: ",'c_ClaveUnidad_id',$c_ClaveUnidad_option_values,$c_ClaveUnidad_option_titles,"col_last");
/*
$f1->createInputDatalist("c_ClaveProdServ_list",$input_values);
$f1->createInputField("Producto SAT: ",'text','c_ClaveProdServ',$c_ClaveProdServ_id_value,NULL,true,false, false, NULL, "c_ClaveProdServ_list");
*/

/********NUEVOS CAMPOS INICIO**********/
//function createTextareaField($field_title,$textarea_name,$textarea_value)
$f1->createTextareaField('Colores','colores',$colores);
$f1->createTextareaField($lang->description.' adicional','descripcion_2',$descripcion_2);
$f1->createTextareaField('Informaci&oacute;n adicional','informacion_adicional',$informacion_adicional);

//createInputField(     TITULO, TIPO,   NOMBRE, VALOR,  CLASES = null,REQUERIDO? = null,MAYUSC = null,actionJS = null,LISTA = null)
$f1->createInputField("Imagen chica",'file','imagen0',"","",false,false,"accept=\"image/png, image/jpeg\"");
echo "	<input type='hidden' name='imagen0-2' value='$imagen0'>";

$f1->createInputField("Imagen grande",'file','imagen1',"","col_last",false,false,"accept=\"image/png, image/jpeg\"");
echo "	<input type='hidden' name='imagen1-2' value='$imagen1'>";

echo "
<div class='col_full'>
	<div class='col-md-6 center'>
		<img src='./catalogoweb-imagen0/$imagen0' alt='Sin imagen chica'>
	</div>
	<div class='col-md-6 center'>
		<img src='./catalogoweb-imagen1/$imagen1' alt='Sin imagen grande'>
	</div>
</div>
<div class='col_full'><hr></div>";

$f1->createInputField("Imagen grande 2",'file','imagen2',"","",false,false,"accept=\"image/png, image/jpeg\"");
echo "	<input type='hidden' name='imagen2-2' value='$imagen2'>";

$f1->createInputField("Imagen grande 3",'file','imagen3',"","col_last",false,false,"accept=\"image/png, image/jpeg\"");
echo "	<input type='hidden' name='imagen3-2' value='$imagen3'>";

echo "
<div class='col_full'>
	<div class='col-md-6 center'>
		<img src='./catalogoweb-imagen2/$imagen2' alt='Sin imagen grande 2'>
	</div>
	<div class='col-md-6 center'>
		<img src='./catalogoweb-imagen3/$imagen3' alt='Sin imagen grande 3'>
	</div>
</div>
<div class='col_full'><hr></div>";

$f1->createInputField("Imagen grande 4",'file','imagen4',"","",false,false,"accept=\"image/png, image/jpeg\"");
echo "	<input type='hidden' name='imagen4-2' value='$imagen4'>";

$f1->createInputField("Imagen grande 5",'file','imagen5',"","col_last",false,false,"accept=\"image/png, image/jpeg\"");
echo "	<input type='hidden' name='imagen5-2' value='$imagen5'>";

echo "
<div class='col_full'>
	<div class='col-md-6 center'>
		<img src='./catalogoweb-imagen4/$imagen4' alt='Sin imagen grande 4'>
	</div>
	<div class='col-md-6 center'>
		<img src='./catalogoweb-imagen5/$imagen5' alt='Sin imagen grande 5'>
	</div>
</div>
<div class='col_full'><hr></div>";
/********NUEVOS CAMPOS FIN**********/
echo "		
	<input type='hidden' name='action' value='$action'>
	<input type='hidden' name='id' value='$id'>";
echo "
	<input type='hidden' name='path_id' value='items/process_form_items'>";
$f1->endForm();

$dbf->closeDBlink();
?>