<?php 
//=======================================
// File Name: xml_4-0.php
//---------------------------------------
// Description: 
// XML parser para CFDI
//=======================================
// Author: Angel Roberto Hernández
//---------------------------------------
// Contact: 
//=======================================

session_start();
date_default_timezone_set('UTC');

include ("../../settings.php");
include ("../../language/$cfg_language");
include ("../../classes/db_functions.php");
include ("../../classes/security_functions.php");


$lang=new language();
$dbf=new db_functions($cfg_server,$cfg_username,$cfg_password,$cfg_database,$cfg_tableprefix,$cfg_theme,$lang);
$sec=new security_functions($dbf,'Public',$lang);

$sale_id= $_REQUEST['saleid'];
$sales_table = $cfg_tableprefix.'sales';
$sales_items_table = $cfg_tableprefix.'sales_items';
$customers_table = $cfg_tableprefix.'sales_customers';
$invoicer_table = $cfg_tableprefix.'invoicer';
$states_table = $cfg_tableprefix.'states';
$items_table = $cfg_tableprefix.'items';
$branch_table = $cfg_tableprefix.'branches';
$c_ClaveProdServ_table = $cfg_tableprefix.'c_ClaveProdServ';
$c_ClaveUnidad_table = $cfg_tableprefix.'c_ClaveUnidad';
$c_UsoCFDI_table = $cfg_tableprefix.'c_UsoCFDI';
$c_RegimenFiscal_table = $cfg_tableprefix.'c_RegimenFiscal';
$c_TipoRelacion_table = $cfg_tableprefix.'c_TipoRelacion';
$item_iva_tax = "0.160000"; 

# datos de venta
$sale_result = mysqli_query($dbf->conn,"SELECT * from $sales_table WHERE id=$sale_id") or die("No existen coincidencias para la venta num $sale_id.");

while($row = mysqli_fetch_array($sale_result))
{
	$tipo_pago=$row["tipo_pago"];
	$folio=$row["folio"];
	$datef=$row["date"];
	$timef=$row["sale_time"];
	$sale_subtotal=($row["sale_sub_total"]+$row["discount"]);
	$sale_total_cost=$row["sale_total_cost"];
	$advance=$row["advance"];
	$datetimef="$datef$timef";
	$original_string=$row["cadena_original"];
	$sello=$row["sello"];
	$discount=$row["discount"];
	$paid_with = $row["paid_with"];
	$digitos_cuenta = $row["digitos_cuenta"];
	$uso_cfdi=$dbf->idToField($c_UsoCFDI_table,'c_UsoCFDI',$row["uso_cfdi"]);
	$TipoRelacion=$dbf->idToField($c_TipoRelacion_table,'c_TipoRelacion',$row["TipoRelacion"]);
	$cfdi_relacionado=$row["cfdi_relacionado"];
	$invoicer_branch_cp=$dbf->idToField($branch_table,'cp',$row["branch_id"]);
}

# detalle de venta
$sales_items_result = mysqli_query($dbf->conn,"SELECT $sales_items_table.sale_id, $sales_items_table.quantity_purchased, $sales_items_table.item_unit_price, $sales_items_table.item_total_cost, $sales_items_table.temp_name, $sales_items_table.afecta, $sales_items_table.branch_id, $sales_items_table.discount, $sales_items_table.item_total_tax, $items_table.item_name, $items_table.item_number, $items_table.description, $items_table.c_ClaveProdServ_id, $items_table.c_ClaveUnidad_id, $items_table.id FROM $sales_items_table JOIN $items_table ON $sales_items_table.item_id = $items_table.id WHERE $sales_items_table.sale_id = $sale_id order by $sales_items_table.id");
	
# datos folios
$folios_header_result =mysqli_query($dbf->conn,"SELECT * FROM folios_header WHERE id = '1'");

while($row = mysqli_fetch_array($folios_header_result))
{
	$ano_aprob=trim($row["ano_aprob"]);
	$serie_cert=trim($row["serie_cert"]);
	$num_aprob=trim($row["num_aprob"]);
	$certificado=trim($row["certificado"]);
}

# detalle de impuesto trasladado
$tax_items_result = mysqli_query($dbf->conn,"SELECT item_unit_price, item_total_cost, quantity_purchased,item_id FROM $sales_items_table WHERE sale_id = $sale_id order by $sales_items_table.id");

# datos de cliente
$customer_result = mysqli_query($dbf->conn,"SELECT * FROM $customers_table WHERE sale_id = $sale_id");
while($row = mysqli_fetch_array($customer_result))
{
	$customer_nameo=$row["name"];
	$customer_rfco=$row["rfc"];
	$customer_street_addresso=$row["street_address"];
	$customer_num_exto=$row["num_ext"];
	$customer_num_int=$row["num_int"];
	$customer_col=$row["col"];
	$customer_del=$row["del"];
	$customer_city=$row["city"];
	$customer_state_id=$row["state_id"];
	$customer_cp=$row["cp"];
	$customer_num=$row["id"];
	$customer_regimenFiscal=$dbf->idToField($c_RegimenFiscal_table,'c_RegimenFiscal',$row["c_RegimenFiscal"]);
}

#Quitamos espacion en blanco e innecesarios
$customer_name = trim($customer_nameo);
$customer_rfc = trim($customer_rfco);
$customer_street_address = trim($customer_street_addresso);
$customer_num_ext = trim($customer_num_exto);
$customer_state_name = $dbf->idToField($states_table,'state',$customer_state_id);

#si el numero interior esta vacio coloca una coma
if(empty($customer_num_int))
{
	$customer_num_int=",";
}

# datos de emisor fiscal
$invoicer_result = mysqli_query($dbf->conn,"SELECT * from $invoicer_table") or die("No existen informacion del emisor fiscal");
while($row = mysqli_fetch_array($invoicer_result))
{
	$invoicer=$row["razon_social"];
	$invoicer_rfc=$row["rfc"];
	$invoicer_street=$row["street"];
	$invoicer_no_exter=$row["no_exter"];
	$invoicer_no_inter=$row["no_inter"];
	$invoicer_colony=$row["colony"];
	$invoicer_delegation=$row["delegation"];
	$invoicer_cp=$row["cp"];
	$invoicer_country=$row["country"];
	$invoicer_city=$row["city"];
	$invoicer_state_id=$row["state_id"];
	$invoicer_phone_number=$row["phone_number"];
	$invoicer_id=$row["id"];
}
$invoicer_state_name = $dbf->idToField($states_table,'state',$invoicer_state_id);

# Reglas de parseo para formato de xml
$customer_name_p = trim($dbf->validXMLdata($customer_name));
$customer_rfc_p = trim($dbf->validXMLdata($customer_rfc));
$customer_street_address_p = trim($dbf->validXMLdata($customer_street_address));
$customer_col_p = trim($dbf->validXMLdata($customer_col));
$customer_del_p = trim($dbf->validXMLdata($customer_del));
$customer_city_p = trim($dbf->validXMLdata($customer_city));
$customer_state_name_p = trim($dbf->validXMLdata($customer_state_name));
$nowdt=$datef."T".$timef;

# Calculo de formas de pago por tipo
if ($tipo_pago ==1 or $tipo_pago ==2 or $tipo_pago ==3)
{
	//$sale_total_cost-=$discount;
	/*
	if ($discount > 0) 
	{
		$sale_subtotal+=$discount;
		$sale_total_cost=$sale_total_cost+($discount*$item_iva_tax);  
	}
	$sale_subtotal=number_format($sale_subtotal-$advance,2,'.','');
	*/
	$sale_subtotal=number_format($sale_subtotal,2,'.','');
	$discount=($discount!="")?number_format($discount,2,'.',''):"";
}
/*
if ($tipo_pago ==2)
{
	unset($sale_subtotal,$sale_total_cost);
	$sale_subtotal=$advance;
	$ftax= $sale_subtotal*$cfg_default_tax_rate/100;
	//$sale_total_cost-=$discount;
	$sale_total_cost=number_format($sale_subtotal+ $ftax,2,'.','');
}
*/
if ($tipo_pago ==3)
{
	unset($sale_total_cost);
	$ftax= $sale_subtotal*$cfg_default_tax_rate/100;
	$sale_total_cost=number_format($sale_subtotal+$ftax,2,'.','');
}

header("Content-type: text/xml");
# Descuento
if($discount>0)// and $tipo_pago<> 2)
{
	$xml_descuento = " Descuento=\"$discount\"";// motivoDescuento=\"Descuento especial\"";
}
else
{
	$xml_descuento = "";
}

$metodo_pago = $paid_with;
$display_digitos_cuenta = '';

/*
if($paid_with == '02' or $paid_with == '03' or $paid_with == '04' or $paid_with == '05' or $paid_with == '07'or $paid_with == '28' or $paid_with == '29' )
{
	trim($digitos_cuenta);
	if($digitos_cuenta != '')
	{
		$display_digitos_cuenta = "NumCtaPago=\"$digitos_cuenta\"";
	}
	else
	{
		$display_digitos_cuenta = "NumCtaPago=\"XXXX\"";
	}
}
*/

//escribe la leyenda para el tipo de pago
if ($tipo_pago ==1)
{
	$tipo_pago_desc="PUE";
}
if ($tipo_pago ==2)
{
	$tipo_pago_desc="PPD";
}
$xml_output = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r";
$xml_output .= "
<cfdi:Comprobante xmlns:cfdi=\"http://www.sat.gob.mx/cfd/4\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.sat.gob.mx/cfd/4 http://www.sat.gob.mx/sitio_internet/cfd/4/cfdv40.xsd\" Version=\"4.0\" Folio=\"$folio\" Fecha=\"$nowdt\" Sello=\"\" NoCertificado=\"$serie_cert\" Certificado=\"$certificado\" SubTotal=\"$sale_subtotal\" Moneda=\"MXN\" Total=\"$sale_total_cost\" TipoDeComprobante=\"I\" FormaPago=\"$metodo_pago\" MetodoPago=\"$tipo_pago_desc\"".$xml_descuento." LugarExpedicion=\"$invoicer_branch_cp\" Exportacion=\"01\">\r";
if ($TipoRelacion != "" && $cfdi_relacionado != "") {
	$xml_output .= "
	<cfdi:CfdiRelacionados TipoRelacion=\"$TipoRelacion\">\r
	<cfdi:CfdiRelacionado UUID=\"$cfdi_relacionado\"/>\r
	</cfdi:CfdiRelacionados>\r";
}
$xml_output .= "
	<cfdi:Emisor Rfc=\"$invoicer_rfc\" Nombre=\"$invoicer\" RegimenFiscal=\"601\"/>\r
	<cfdi:Receptor Rfc=\"$customer_rfc_p\" Nombre=\"$customer_name_p\" DomicilioFiscalReceptor=\"$customer_cp\" RegimenFiscalReceptor=\"$customer_regimenFiscal\" UsoCFDI=\"$uso_cfdi\" />\r
	<cfdi:Conceptos>\r";


					//			$xml_descuento $display_digitos_cuenta 
$enies = array('Ñ', 'ñ');
$enes = array('N', 'n');
/*
if ($tipo_pago==2)
	{	
		$item_name_pc='';
		
		while($row = mysqli_fetch_array($sales_items_result))
			{
				$quantity_purchased=$row['quantity_purchased'];
				$temp_aname=trim($row['temp_name']);
				$item_id=$row['id'];
				$item_name=trim($row['item_name']);
				
				if ($item_name=="ARTICULO TEMPORAL")
					{
						$item_name=$temp_aname; 
					}
				# Reglas de parseo XML
				$item_name_p=$dbf->validXMLdata(str_replace($enies,$enes,$item_name));
				
			$item_name_pc = "$item_name_pc"." $item_name_p";
			$unitario=$advance*$cfg_default_tax_rate/100+$advance;
			$unitario_f=number_format($unitario,2,'.','');
				
			}
			$item_name_pc_t= trim($item_name_pc);
			$xml_output .= "		<cfdi:Concepto ClaveProdServ=\"01010101\" ClaveUnidad=\"H87\" NoIdentificacion=\"00001\" Cantidad=\"1\" Unidad=\"Pieza\" Descripcion=\"$item_name_pc_t\" ValorUnitario=\"$advance\" Importe=\"$advance\"/>\r";
	}
	
else
*/

$tax_base=0;
if ($tipo_pago==5)
	{
		$item_name_p='Articulos segun notas de venta: ' . $f_cons;
		$quantity_purchased='1';
		# Reglas de parseo XML
		$item_name_pr=$dbf->validXMLdata(str_replace($enies,$enes,$item_name_p));
		$xml_output .= "		<cfdi:Concepto ClaveProdServ=\"01010101\" ClaveUnidad=\"H87\" NoIdentificacion=\"00001\" Cantidad=\"$quantity_purchased\" Unidad=\"Pieza\" Descripcion=\"$item_name_pr\" ValorUnitario=\"$sale_subtotal\" Importe=\"$sale_subtotal\"/>\r";
	}
				
else
	{	
	    $item_total_taxes=0;
		while($row = mysqli_fetch_array($sales_items_result))
			{
				$quantity_purchased=number_format($row['quantity_purchased'],6,'.','');
				$item_name=trim($row['item_name']);
				$item_unit_price=number_format($row['item_unit_price'],2,'.','');
				$item_total_cost=number_format(($row['item_total_cost']+$row['discount']),2,'.','');
				//$item_total_cost=number_format(($row['item_total_cost']),2,'.','');
				$item_discount=($row['discount']!="")?number_format($row['discount'],2,'.',''):"";
				$temp_aname=trim($row['temp_name']);
				$item_id=$row['id'];
				$item_number=trim($row['item_number']);
				$c_ClaveProdServ=$dbf->idToField($c_ClaveProdServ_table,'c_ClaveProdServ',$row['c_ClaveProdServ_id']);
				$c_ClaveUnidad=$dbf->idToField($c_ClaveUnidad_table,'c_ClaveUnidad',$row['c_ClaveUnidad_id']);
				$c_Unidad=$dbf->idToField($c_ClaveUnidad_table,'Nombre',$row['c_ClaveUnidad_id']);
				//$item_iva_tax_importe = $item_iva_tax * ($item_total_cost-$item_discount);
				$item_iva_tax_importe = $row['item_total_tax'];
				$item_total_taxes+=$item_iva_tax_importe; 
				
				if ($item_discount != "") {
					$item_discount = " Descuento=\"$item_discount\"";
				}
				if ($item_name=="ARTICULO TEMPORAL")
					{
						$item_name=$temp_aname; 
					}
				# Reglas de parseo XML
				$temp_aname_p=$dbf->validXMLdata($temp_aname);
				$item_name_p=$dbf->validXMLdata(str_replace($enies,$enes,$item_name));
				
				$xml_output .= "		<cfdi:Concepto ClaveProdServ=\"$c_ClaveProdServ\" ClaveUnidad=\"$c_ClaveUnidad\" NoIdentificacion=\"$item_number\" Cantidad=\"$quantity_purchased\" Unidad=\"$c_Unidad\" Descripcion=\"$item_name_p\" ValorUnitario=\"$item_unit_price\" Importe=\"$item_total_cost\"".$item_discount." ObjetoImp=\"02\">\r";
				$tax_base += $row['item_total_cost'];
				$item_total_cost=number_format($row['item_total_cost'],2,'.','');
				$xml_output .= "
				<cfdi:Impuestos>\r
					<cfdi:Traslados>\r
						<cfdi:Traslado Base=\"$item_total_cost\" Impuesto=\"002\" TipoFactor=\"Tasa\" TasaOCuota=\"$item_iva_tax\" Importe=\"$item_iva_tax_importe\" />\r
					</cfdi:Traslados>\r
				</cfdi:Impuestos>\r";
				$xml_output .= "		</cfdi:Concepto>\r";
			}
	}			
	
$xml_output .= "		</cfdi:Conceptos>\r";

# Aplica el IVA para el parseo de los impuestos	en anticipo
if ($tipo_pago==2)
{
	$taxa=($advance*$cfg_default_tax_rate/100);
	$taxaf=number_format($taxa,2,'.','');
}

//$total_tax = $sale_total_cost-$sale_subtotal+$discount;
//$total_tax = $sale_total_cost * $item_iva_tax;
$total_tax = $item_total_taxes;
$total_tax_f = number_format($total_tax,2,'.','');
if ($tipo_pago==2)
{
	$xml_output .= "	<cfdi:Impuestos TotalImpuestosTrasladados=\"$total_tax_f\">
		<cfdi:Traslados>\r";
}
else
{
	$xml_output .= "	<cfdi:Impuestos TotalImpuestosTrasladados=\"$total_tax_f\">
		<cfdi:Traslados>\r";
}

$tax_base=number_format($tax_base,2,'.','');
if ($tipo_pago==2)
{
	$xml_output .="			<cfdi:Traslado Base=\"$tax_base\" Impuesto=\"002\" TipoFactor=\"Tasa\" TasaOCuota=\"$item_iva_tax\" Importe=\"$total_tax_f\" />\r";
}
elseif ($tipo_pago==5)
{
	$taxa=($sale_subtotal*$cfg_default_tax_rate/100);
	$taxaf=number_format($taxa,2,'.','');
	$xml_output .="			<cfdi:Traslado Base=\"$tax_base\" Impuesto=\"002\" TipoFactor=\"Tasa\" TasaOCuota=\"$item_iva_tax\" Importe=\"$total_tax_f\" />\r";
}
else
{		
	/*
	while($row = mysqli_fetch_array($tax_items_result))
		{
			$item_id=$row['item_id'];
			$item_unit_price =$row['item_unit_price'];
			$item_quantity_purchased =$row['quantity_purchased'];	
			$taxa=($item_unit_price*$cfg_default_tax_rate/100)*$item_quantity_purchased;
			$taxaf=number_format($taxa,2,'.','');
			*/
			
	$xml_output .="			<cfdi:Traslado Base=\"$tax_base\" Impuesto=\"002\" TipoFactor=\"Tasa\" TasaOCuota=\"$item_iva_tax\" Importe=\"$total_tax_f\" />\r";
			/*
		}
		*/
}		

$xml_output .= "
		</cfdi:Traslados>
	</cfdi:Impuestos>";


$xml_output .= "
</cfdi:Comprobante>";

echo $xml_output;
?> 