<?php 
session_start(); 
error_reporting(0);

include ("../settings.php");
include ("../language/$cfg_language");
include ("../classes/db_functions.php");
include ("../classes/security_functions.php");
include ("../classes/form.php");
include ("../classes/display.php");

$lang=new language();
$dbf=new db_functions($cfg_server,$cfg_username,$cfg_password,$cfg_database,$cfg_tableprefix,$cfg_theme,$lang);
$sec=new security_functions($dbf,'Sales Clerk',$lang);
$display=new display($dbf->conn,$cfg_theme,$cfg_currency_symbol,$lang);

if(!$sec->isLoggedIn())
{
	header ("location: ../login.php");
	exit();
}
$title_form = "Agregar parcialidad";

if(isset($_GET['sale_id']))
{
	$sale_id=$_GET['sale_id'];
	$tablename_sale = $cfg_tableprefix.'sales';
	$tablename_ppd = $cfg_tableprefix.'sales_ppd';

	$result_sale = mysqli_query($dbf->conn,"SELECT sale_total_cost, branch_id, CONVERT(timbre_fiscal,CHAR) AS timbre FROM $tablename_sale WHERE id=\"$sale_id\" AND tipo_pago = \"2\" AND timbre_fiscal <> \"\" ORDER BY id DESC");
	$row_sale = mysqli_fetch_assoc($result_sale);
	$parcialidad = 1;
	$branch_id=$row_sale['branch_id'];
	$saldo_anterior=$row_sale['sale_total_cost'];
	$serie=$dbf->idToField("branches",'branch_short_name',$branch_id);
	$timbre_fiscal=$row_sale['timbre'];
	$xml_fiscal = simplexml_load_string($timbre_fiscal);
	foreach ($xml_fiscal->xpath('//cfdi:Comprobante//cfdi:Complemento//tfd:TimbreFiscalDigital') as $TimbreFiscalDigital)
	$parent_UUID = $TimbreFiscalDigital['UUID'];
	if ($parent_UUID == "")
	{
		$parent_UUID = $dbf->extractDataXML($timbre_fiscal, "UUID");
	}

	$result_folio = mysqli_query($dbf->conn,"SELECT folio FROM $tablename_ppd WHERE branch_id=\"$branch_id\" ORDER BY id DESC");
	if($row_folio = mysqli_fetch_assoc($result_folio)){
		$folio = $row_folio['folio'] + 1;
	}else{
		$folio = 1;
	}
	if ($folio < 10) {
		$folio = "00" . $folio;
	}elseif($folio < 100){
		$folio = "0" . $folio;
	}

	$result_ppd = mysqli_query($dbf->conn,"SELECT parcialidad, saldo FROM $tablename_ppd WHERE sale_id=\"$sale_id\" and timbre_fiscal <> \"\" ORDER BY id DESC");
	if($row_ppd = mysqli_fetch_assoc($result_ppd))
	{
		$parcialidad=$row_ppd['parcialidad'] + 1;
		$saldo_anterior=$row_ppd['saldo'];
		//$serie=$row_ppd['serie'];
		//$folio=$row_ppd['folio'] + 1;
		//$parent_UUID=$row_ppd['parent_UUID'];
	}
}

$f1=new form('index.php','POST','ppd',$title_form,$lang,true);
//$f1->createInputField($lang->rfc,'text','rfc',$rfc_value,NULL,true,true,"oninput=\"genericCustomer(this.value)\" pattern=\"[A-Z,Ñ,&]{3,4}[0-9]{2}[0-1][0-9][0-3][0-9][A-Z,0-9]?[A-Z,0-9]?[0-9,A-Z]?\"");
$f1->createInputField("Parcialidad",'text','parcialidad',$parcialidad,NULL,true,true," readonly ");
$f1->createInputField("Documento relacionado",'text','parent_UUID',$parent_UUID,"col_last",true,true," readonly ");
$c_FormaPago = $cfg_tableprefix.'c_FormaPago';
$f1->createInputField("Saldo",'text','saldo_anterior_',$display->formatData('amount',$saldo_anterior,$tableprefix),NULL,true,true," readonly ");
$type_paid_with_option_titles=$dbf->getAllElements($c_FormaPago,'Descripcion','id');
$type_paid_with_option_values=$dbf->getAllElements($c_FormaPago,'c_FormaPago','id');
$f1->createSelectField("Forma de pago",'paid_with',$type_paid_with_option_values,$type_paid_with_option_titles,"col_last");
$f1->createInputField("Abono $",'number','pagado',"",NULL,true,true, " min=\"1\" max=\"$saldo_anterior\" ");

echo "
	<input type='hidden' name='sale_id' value='$sale_id'>
	<input type='hidden' name='saldo_anterior' value='$saldo_anterior'>
	<input type='hidden' name='serie' value='$serie'>
	<input type='hidden' name='branch_id' value='$branch_id'>
	<input type='hidden' name='folio' value='$folio'>
	<input type='hidden' name='tipo_relacion' value='0'>
	<input type='hidden' name='path_id' value='sales/process_form_ppd'>";
$f1->endForm();
?>
